
local screenSize = vec2(987, 410)
local colorCover = rgbm(0, 0, 0, 1)
local colorWhite = rgbm(1, 1, 1, 1)
local colorHover = rgbm(0.2, 0.2, 0.2, 1)
local frLift = false
ac.store(frontLift, 0)

local buttons = {
  { points = {vec2(0, -15), vec2(140, -15), vec2(140, 80), vec2(0, 80)} },
  { points = { vec2(140, -15), vec2(250, -15), vec2(250, 80), vec2(140, 80) }, screen = "NAVIGATOR_0" },
  { points = { vec2(250, -15), vec2(300, -15), vec2(300, 80), vec2(250, 80) } },
  { points = { vec2(300, -15), vec2(455, -15), vec2(455, 80), vec2(300, 80) }, screen = "CAR_STEREO_0" },
  { points = { vec2(455, -15), vec2(515, -15), vec2(515, 80), vec2(455, 80) } },
  { points = { vec2(515, -15), vec2(570, -15), vec2(570, 80), vec2(515, 80) }, screen = "AGERA_RS" },
  { points = { vec2(570, -15), vec2(600, -15), vec2(600, 80), vec2(570, 80) } },
  { points = { vec2(600, -15), vec2(760, -15), vec2(760, 80), vec2(600, 80) }, screen = "RADIO" },
  { points = { vec2(760, -15), vec2(790, -15), vec2(790, 80), vec2(760, 80) } },
  { points = { vec2(790, -15), vec2(1035, -15), vec2(1035, 80), vec2(790, 80) }, screen = "RENDERING_CAMERA_0" },
  { points = { vec2(1035, -15), vec2(1100, -15), vec2(1100, 80), vec2(1035, 80) } },
}

local startingMode = tonumber(ac.loadDisplayValue("startingMode", 2)) or 1
local previousSection = startingMode
local currentSection = startingMode
local activationProgress = 0
local gearsGrowth = {}

local radio = {
  player = ui.MediaPlayer(),
  --tuningPlayer = ui.MediaPlayer(),
  station = nil,
  volume = 0.10,
  state = 0
}

radio.player:setVolume(ac.getAudioVolume('main') * radio.volume)
--radio.tuningPlayer:setVolume(ac.getAudioVolume('main') * radio.volume)
local player = ui.MediaPlayer()

local stations = {
  {
    title = "Nostalgie",
    thumbnail = "https://1.bp.blogspot.com/-ZOU4DFm0nVg/W_XFJKf9agI/AAAAAAAAI_4/iRJlJolRBP4CX2ziPxQry-k7prqRooCbwCKgBGAs/s400/Nostalgie%2BBelgique.jpg",
    streamURL = "http://scdn.nrjaudio.fm/adwz2/fr/30601/mp3_128.mp3?origine=fluxradios"
  },
  {
    title = "Radio Classique",
    thumbnail = "https://1.bp.blogspot.com/-w8k2iObhCzg/W_XHCoHWS2I/AAAAAAAAJAU/-h1c-WiEFhAR3_2VbVvYNdK6MdIKh_mDwCKgBGAs/s400/Radio%2BClassique%2B%253B%2B%2528001%2529.png",
    streamURL = "http://radioclassique.ice.infomaniak.ch/radioclassique-high.mp3"
  },
  {
    title = "NRJ",
    thumbnail = "https://upload.wikimedia.org/wikipedia/fr/c/ca/Nrj2014.png",
    streamURL = "http://scdn.nrjaudio.fm/adwz2/fr/30001/mp3_128.mp3?origine=fluxradios"
  },
  {
    title = "Rire &\nChansons",
    thumbnail = "https://upload.wikimedia.org/wikipedia/fr/thumb/8/84/Logo-rire-et-chansons-2020.png/480px-Logo-rire-et-chansons-2020.png",
    streamURL = "http://scdn.nrjaudio.fm/adwz2/fr/30401/mp3_128.mp3?origine=fluxradios"
  },
  {
    title = "RFM",
    thumbnail = "https://upload.wikimedia.org/wikipedia/fr/1/19/RFM_logo_2011.png",
    streamURL = "https://ais-live.cloud-services.paris:8443/rfm.mp3"
  },
  {
    title = "Jazz24",
    thumbnail = "https://play-lh.googleusercontent.com/mlIgk5za6agmnP9S3DTzMf9Ug1cG6pWi1a50rAtyohfrvQ8eJZpamk9vFELSQNUixuJ5",
    streamURL = "https://prod-34-82-251-170.wostreaming.net/ppm-jazz24mp3-ibc1?session-id=61aceab16e5ee45ce599a6e6d194d0e1"
  }
}

radio.station = stations[4]

function update(dt)
  -- Updating state
  if currentSection ~= previousSection then
    activationProgress = math.max(0, activationProgress - dt * 3)
    if activationProgress == 0 then
      ac.setDynamicTextureShift(buttons[previousSection].screen, 0)
      previousSection = currentSection
    end
  elseif activationProgress < 1 then
    activationProgress = math.min(1, activationProgress + dt * 3)
  end
  ac.setDynamicTextureShift(buttons[previousSection].screen, activationProgress)

  -- A bit of a placeholders (temporary?) for missing sections
  if buttons[previousSection].screen == nil then
    -- Restoring original background
    display.image{ image = "assets/koenigsegg.dds", pos = vec2(), size = vec2(1100, 510) }

    if previousSection == 6 then
      settings()
    elseif buttons[previousSection].title ~= nil then
      ui.pushStyleVar(ui.StyleVar.Alpha, activationProgress)
      display.rect{ pos = vec2(), size = vec2(1024, 668), color = rgbm(0, 0, 0, 0.9) }
      display.text{ 
        text = buttons[previousSection].title, 
        pos = vec2(320, 300), 
        letter = vec2(20, 50),
        font = "sls",
        width = 400,
        alignment = 0.5
      }
      ui.popStyleVar()
    end
  end

  -- Buttons, also useful to recreate the curved mask
  local hoveredButton = 0
  ui.beginTextureSaturationAdjustment()         -- adjusting texture to hide original selection
  ui.setShadingOffset(1, 0)                  -- this one is for color×2-0.5, along with desaturation hides selection
  ui.beginTextureShade("assets/koenigsegg.dds")  -- all shapes drawn here will get a texture mapped on top of them
  for i = 1, #buttons do
    local btn = buttons[i].points
    if ui.rectHovered(btn[1], btn[3]) then
      hoveredButton = i
      if ui.mouseClicked() then currentSection = i end
    end
    ui.drawQuadFilled(btn[1], btn[2], btn[3], btn[4], colorWhite)
  end
  ui.endTextureSaturationAdjustment(1)
  ui.endTextureShade(vec2(), vec2(1090, 490))
  ui.setShadingOffset()

  -- Reception indicator to reduce in tunnels or with bad weather
  local satelliteOcclusion = ac.estimateSatelliteOcclusion()
  if satelliteOcclusion < 0.25 then
    display.rect{ pos = vec2(340.8, 382.4), size = vec2(16.8, 19.8), color = colorCover }
  elseif satelliteOcclusion < 0.5 then
    display.rect{ pos = vec2(346.1, 382.1), size = vec2(11.7, 19.4), color = colorCover }
  elseif satelliteOcclusion < 0.75 then
    display.rect{ pos = vec2(351.5, 382.4), size = vec2(5.7, 19.1), color = colorCover }
  end

  if currentSection == 6 then
    DisplayAgeraPage()
    extraSettings()
  end
  
  if currentSection == 8 then
    ac.setRenderingCameraActive("RENDERING_CAMERA_0", false)
    DisplayRadioPage()
  end


  if currentSection == 10 then
        -- Gear is reverse!
    ac.setDynamicTextureShift("NAVIGATOR_0", 0)  -- let’s stop navigator
    ac.setDynamicTextureShift("CAR_STEREO_0", 0)  -- let’s stop navigator
    ac.setDynamicTextureShift("CAR_STEREO_1", 0)  -- let’s stop navigator
    ac.setRenderingCameraActive("RENDERING_CAMERA_0", true)  -- activate rendering camera
    display.image{pos = vec2(115,80), size = vec2(950, 375), image = "dynamic::camera_rear_distorted"}  -- and draw fisheye camera

  -- And we’re done! But for a bit of extra authenticity let’s add lines with trajectory:
  local startL = vec2(325, 460)  -- one thing to note: I haven’t really properly calibrated those lines yet
  local startR = vec2(850, 460)
  local direction = vec2(25, -25):normalize()
  local lineLen = 220
  local steps = 9
  local steerOffset = -car.steer * 0.15
  local currentPosL = startL
  local currentPosR = startR
  local color = rgbm(1, 0, 0, 1)
  for i = 1, steps do
    local newPosL = startL + direction * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
    local newPosR = startR + vec2(-direction.x, direction.y) * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
    local drawAcrossColor = color
    if i == 4 then
      color = rgbm(1, 1, 0, 1)
    elseif i == 7 then
      color = rgbm(0, 1, 0, 1)
    else
      drawAcrossColor = i == 9 and color or nil
    end
    ui.drawLine(currentPosL, newPosL, color, 4)
    ui.drawLine(currentPosR, newPosR, color, 4)
    if drawAcrossColor ~= nil then
      ui.drawLine(currentPosL, currentPosR, drawAcrossColor, 4)
    end
    currentPosL = newPosL
    currentPosR = newPosR
    direction:add(vec2(0, 0.02)):normalize()
  end

  -- And a warning:
  display.rect{pos = vec2(375, 81.5), size = vec2(396, 32), color = rgbm(0, 0, 0, 0.8 )}
  display.text{pos = vec2(375, 90), letter = vec2(12, 20), text = "Check surroundings for safety", font = "aria", width = 396, alignment = 0.5 }
  end




  if car.gear ~= -1 then  
    -- If gear is not reverse, activate navigator:
    ac.setRenderingCameraActive("NAVIGATOR_0", 1)  -- pause rendering camera
    return  -- and we’re done here, so let’s stop
  end

  -- Gear is reverse!
  ac.setDynamicTextureShift("NAVIGATOR_0", 0)  -- let’s stop navigator
  ac.setDynamicTextureShift("CAR_STEREO_0", 0)  -- let’s stop navigator
  ac.setDynamicTextureShift("CAR_STEREO_1", 0)  -- let’s stop navigator
  ac.setRenderingCameraActive("RENDERING_CAMERA_0", true)  -- activate rendering camera
  display.image{pos = vec2(115,80), size = vec2(950, 375), image = "dynamic::camera_rear_distorted"}  -- and draw fisheye camera

  -- And we’re done! But for a bit of extra authenticity let’s add lines with trajectory:
  local startL = vec2(325, 460)  -- one thing to note: I haven’t really properly calibrated those lines yet
  local startR = vec2(850, 460)
  local direction = vec2(25, -25):normalize()
  local lineLen = 220
  local steps = 9
  local steerOffset = -car.steer * 0.15
  local currentPosL = startL
  local currentPosR = startR
  local color = rgbm(1, 0, 0, 1)
  for i = 1, steps do
    local newPosL = startL + direction * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
    local newPosR = startR + vec2(-direction.x, direction.y) * (i * (lineLen / steps)) + vec2(steerOffset * (i / steps) ^ 2, 0)
    local drawAcrossColor = color
    if i == 4 then
      color = rgbm(1, 1, 0, 1)
    elseif i == 7 then
      color = rgbm(0, 1, 0, 1)
    else
      drawAcrossColor = i == 9 and color or nil
    end
    ui.drawLine(currentPosL, newPosL, color, 4)
    ui.drawLine(currentPosR, newPosR, color, 4)
    if drawAcrossColor ~= nil then
      ui.drawLine(currentPosL, currentPosR, drawAcrossColor, 4)
    end
    currentPosL = newPosL
    currentPosR = newPosR
    direction:add(vec2(0, 0.02)):normalize()
  end

  -- And a warning:
  display.rect{pos = vec2(375, 81.5), size = vec2(396, 32), color = rgbm(0, 0, 0, 0.8 )}
  display.text{pos = vec2(375, 90), letter = vec2(12, 20), text = "Check surroundings for safety", font = "aria", width = 396, alignment = 0.5 }
end

function DisplayRadioPage()
  setWallpaper()
  DisplayVolumeBars(vec2(650,280), radio.volume * 10, LowerRadioVolume, RaiseRadioVolume)
  DisplayRadioCountryList()
  DisplayCurrentRadioStation(radio.station.thumbnail, radio.station.title)
  DisplayRadioButtons()
  Numstation ()
end

function DisplayVolumeBars(pos, value, LowerFunction, RaiseFuction)
  local offset = vec2(12, 0)
  local color
  for i = 1, 10 do
      if (value > i) then
          color = rgbm(1, 1, 1, 1)
      else
          color = rgbm(0.1, 0.1, 0.1, 1)
      end
      display.rect { -- just draw a simple rect for each bit in series
          pos = pos + offset * (i - 1), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
          size = vec2(6, 25),
          color = color
      }
  end

  ui.drawImage("./icons/plus.png", pos + offset * (10 - 1) + vec2(10, 0), -- ./icons/play.png
  pos + offset * (10 - 1) + vec2(10, 0) + 25, colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(pos + offset * (10 - 1) + vec2(10, 0), pos + offset * (10 - 1) + vec2(10, 0) + 25) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/plus.png", pos + offset * (10 - 1) + vec2(10, 0),
          pos + offset * (10 - 1) + vec2(10, 0) + 25, colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
          RaiseFuction()
      end
  end

  ui.drawImage("./icons/minus.png", pos + vec2(-30, 0), -- ./icons/play.png
  pos + vec2(-30, 0) + 25, colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(pos + vec2(-30, 0), pos + vec2(-30, 0) + 25) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/minus.png", pos + vec2(-30, 0), pos + vec2(-30, 0) + 25, colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
          LowerFunction()
      end
  end

end

function RaiseRadioVolume()
  if (radio.volume < 1.0) then
      radio.volume = radio.volume + 0.1
      radio.player:setVolume(ac.getAudioVolume('main') * radio.volume)
      --radio.tuningPlayer:setVolume(ac.getAudioVolume('main') * radio.volume)
  end
end

function LowerRadioVolume()
  if (radio.volume > 0.1) then
      radio.volume = radio.volume - 0.1
      radio.player:setVolume(ac.getAudioVolume('main') * radio.volume)
      --radio.tuningPlayer:setVolume(ac.getAudioVolume('main') * radio.volume)
  end
end

function DisplayRadioCountryList()

  local posy = 0
  local posx = -1
  for i = 1, #stations do
      posx = posx + 1
      if i > 6 then
          break
          if (posx > 4) then
              posx = 0
          end
          posy = 0
      end
      createHomeMenuButton(stations, rgbm(0.1, 0.1, 0.1, 1), posx, posy, "" -- stations[i].title
      , function ()
          radio.station = stations[i]
          PlayRadioStation(stations[i].streamURL)
          radio.state = true
      end, stations[i].title, stations[i].thumbnail, vec2(225, 340), vec2(0, screenSize.y / 2 + 420))
  end
end

function createHomeMenuButton(text, color, positionX, positionY, state, method, on, image, p1, p2)
  local hoverColor = rgbm(0.4, 0.4, 0.4, 1)
  local buttonDistanceX = 25
  local buttonDistanceY = 50
  local padding = 10
  local paddingText = 5
  local size = (p2 - p1) / 3
  size = vec2(size.y, size.y)

  local newp1 = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                    vec2(buttonDistanceX * positionX, buttonDistanceY * positionY)
  local newp2 = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                    vec2(buttonDistanceX * positionX, buttonDistanceY * positionY) + vec2(size.x, size.y)
  if image ~= nil then
      ui.drawImage(image, newp1, newp2) -- ,rgbm.colors.white,vec2(0, 0),vec2(1, 1),true)
  end
  local textLocation = vec2(padding, padding) + vec2(p1.x, p1.y) + vec2(size.x * positionX, size.y * positionY) +
                           vec2(buttonDistanceX * positionX, buttonDistanceY * positionY) +
                           vec2(-size.x / 2, size.y + paddingText)
  display.text {
      text = state,
      pos = textLocation,
      color = colorWhite,
      letter = vec2(10, 25),
      font = "sls",
      width = 200,
      alignment = 0.5
  }
  if ui.rectHovered(newp1, newp2 + vec2(0, 30)) then
      -- ui.drawRect(newp1, newp2, hoverColor, 10, 15, 1.5)
      if image ~= nil then
          ui.drawImage(image, newp1, newp2, hoverColor) -- ,rgbm.colors.white,vec2(0, 0),vec2(1, 1),true)
      end
      if ui.mouseClicked() then
          method()
      end
  end
end

function PlayRadioStation(radioStationStream)
  radio.player:setSource(radioStationStream)
  radio.player:play()
end

function DisplayCurrentRadioStation(stationImage, stationTitle)
  ui.drawImage(stationImage, vec2(150, 115), vec2(screenSize.x / 2, screenSize.y / 1.3 ), false)
  display.text({
      text = stationTitle,
      pos = vec2(ui.windowWidth() - 500, 120),
      letter = vec2(25 * 1.5, 35 * 1.5),
      font = 'aria',
      color = rgbm.colors.white,
      width = 250,
      alignment = 0.5
  })
end

function DisplayRadioButtons()

  if (radio.player:playing()) then
      ui.drawImage("./icons/volume_high.png", vec2(screenSize.x - 295, 230), vec2(screenSize.x - 270, 255), colorWhite)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
      -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
      if ui.rectHovered(vec2(screenSize.x - 295, 230), vec2(screenSize.x - 270, 255)) then
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
          ui.drawImage("./icons/volume_high.png", vec2(screenSize.x - 295, 230), vec2(screenSize.x - 270, 255),
              colorHover)
          -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
          if ui.mouseClicked() then
              radio.player:pause()
              radio.state = false
          end
      end
  else
      ui.drawImage("./icons/mute.png", vec2(screenSize.x - 295, 230), vec2(screenSize.x - 270, 255), colorWhite)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
      -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
      if ui.rectHovered(vec2(screenSize.x - 295, 230), vec2(screenSize.x - 270, 255)) then
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
          ui.drawImage("./icons/mute.png", vec2(screenSize.x - 295, 230), vec2(screenSize.x - 270, 255), colorHover)
          -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
          -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
          if ui.mouseClicked() then
              radio.player:play()
              radio.state = true
          end
      end
  end

  ui.drawImage("./icons/next.png", vec2(screenSize.x - 327, 230), vec2(screenSize.x - 352, 255), colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(vec2(screenSize.x - 352, 230), vec2(screenSize.x - 327, 255)) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/next.png", vec2(screenSize.x - 327, 230), vec2(screenSize.x - 352, 255), colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
        Prevstation()
          -- currentScreen = previousScreen[1]
          -- table.remove(previousScreen, 1)
          -- ui.toast(ui.Icons.Apps, ac.getCameraPosition())
      end
  end

  ui.drawImage("./icons/next.png", vec2(screenSize.x - 235, 230), vec2(screenSize.x - 210, 255), colorWhite)
  -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,1,1), 20, 3)
  -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,1,1), 20)
  -- ui.drawRect(vec2(10, 50), vec2(40, 80), rgbm(1,0,0,1))
  if ui.rectHovered(vec2(screenSize.x - 235, 230), vec2(screenSize.x - 210, 255)) then
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 71), 9, rgb(1,1,1), 20)
      ui.drawImage("./icons/next.png", vec2(screenSize.x - 235, 230), vec2(screenSize.x - 210, 255), colorHover)
      -- ui.drawCircle(vec2(41, ui.windowHeight() - 70), 14, rgb(1,0,1), 20, 3)
      -- ui.drawCircleFilled(vec2(41, ui.windowHeight() - 70), 9, rgb(1,0,1), 20)
      if ui.mouseClicked() then
        Nextstation()
          -- currentScreen = previousScreen[1]
          -- table.remove(previousScreen, 1)
          -- ui.toast(ui.Icons.Apps, ac.getCameraPosition())
      end
    end
end

function setWallpaper()

  display.rect { -- just draw a simple rect for each bit in series
      pos = vec2(50,80), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
      size = vec2(987, 410),
      color = rgbm(0, 0, 0, 1)
  }

  display.image({
      image = "black.dds",
      pos = vec2(50,80),
      size = vec2(987, 410),
      color = rgbm(0.25, 0.25, 0.25, 1)
  })

end

function Numstation ()
  local stationnum = 0
  for i = 1, table.getn(stations), 1 do
    if radio.station.title == stations[i].title then
      stationnum = i
    end
  end

  function Prevstation()
    if stationnum > 1 then
      stationnum = stationnum - 1
      radio.station = stations[stationnum]
      PlayRadioStation(stations[stationnum].streamURL)
      radio.state = true
    end
  end

  function Nextstation()
    if stationnum < table.getn(stations) then
      stationnum = stationnum + 1
      radio.station = stations[stationnum]
      PlayRadioStation(stations[stationnum].streamURL)
      radio.state = true
    end
  end
end

function DisplayAgeraPage()
  setAgeraWallpaper()
end

function setAgeraWallpaper()

  display.rect { -- just draw a simple rect for each bit in series
      pos = vec2(115,80), -- for first element (i==1) offset is zero, for others multiply step by (i - 1)
      size = vec2(950, 375),
      color = rgbm(0, 0, 0, 1)
  }

  display.image({
      image = "assets/agera_rs.dds",
      pos = vec2(115,80),
      size = vec2(950, 375),
      color = rgbm(1, 1, 1, 1)
  })

end

function extraSettings()

  local settings = {{
      text = "Extra A",
      stateText = function()
          if (ac.getCar().extraA == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraA,
      method = function()
          ac.setExtraSwitch(0, not ac.getCar().extraA)
      end
  }, {
      text = "Extra B",
      stateText = function()
          if (ac.getCar().extraB == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraB,
      method = function()
          ac.setExtraSwitch(1, not ac.getCar().extraB)
      end
  }, {
      text = "Extra C",
      stateText = function()
          if (ac.getCar().extraC == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraC,
      method = function()
          ac.setExtraSwitch(2, not ac.getCar().extraC)
      end
  }, {
      text = "Extra D",
      stateText = function()
          if (ac.getCar().extraD == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraD,
      method = function()
          ac.setExtraSwitch(3, not ac.getCar().extraD)
      end
  }, {
      text = "Extra E",
      stateText = function()
          if (ac.getCar().extraE == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraE,
      method = function()
          ac.setExtraSwitch(4, not ac.getCar().extraE)
      end
  }, {
      text = "Extra F",
      stateText = function()
          if (ac.getCar().extraF == true) then
              return "ON"
          else
              return "OFF"
          end
      end,
      state = ac.getCar().extraF,
      method = function()
          ac.setExtraSwitch(5, not ac.getCar().extraF)
      end
  }, {
    text = "Front Lift",
    stateText = function()
        if (ac.load(frontLift) == 1) then
            return "ON"

        else
            return "OFF"
        end
    end,
    state = frLift,
    method = function()
        if (ac.load(frontLift) == 1) then
          ac.store(frontLift, 0)
          frLift = false
      else
        ac.store(frontLift, 1)
        frLift = true
      end
    end
}}
  local posy = 0
  local posx = -1
  for i = 1, #settings do
      local setting = settings[i].text
      posx = posx + 1
      if i > 3 then
          if (posx > 2) then
              posx = 0
          end
          posy = 1
      end
      createSettingButton(setting, rgbm(0.1, 0.1, 0.1, 1), posx, posy, settings[i].stateText(), settings[i].method,
          settings[i].state)
  end
end

function createSettingButton(text, color, positionX, positionY, state, method, on, image)
    local offColor = rgbm(0.8, 0.8, 0.8, 1)
    local onColor = rgbm(1, 0.1, 0, 1)


  if (on) then
      color = onColor
  else
      color = offColor
  end

  if text == "Extra A" then
    --ui.drawRect(vec2(540,145), vec2(560,165), rgbm(0.8, 0.8, 0.8, 1), 20, 15, 10)
    ui.drawCircle(vec2(550, 155), 10, color, 25, 10)

    if ui.rectHovered(vec2(540,145), vec2(560,165)) then
      ui.drawCircle(vec2(550, 155), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
        method()
      end
    end
  end

  if text == "Extra B" then
    --ui.drawRect(vec2(540,145), vec2(560,165), rgbm(0.8, 0.8, 0.8, 1), 20, 15, 10)
    ui.drawCircle(vec2(250, 290), 10, color, 25, 10)

    if ui.rectHovered(vec2(240,280), vec2(260,300)) then
      ui.drawCircle(vec2(250, 290), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
          method()
      end
    end
  end

  if text == "Extra C" then
    --ui.drawRect(vec2(540,145), vec2(560,165), rgbm(0.8, 0.8, 0.8, 1), 20, 15, 10)
    ui.drawCircle(vec2(800, 150), 10, color, 25, 10)

    if ui.rectHovered(vec2(790,140), vec2(810,160)) then
      ui.drawCircle(vec2(800, 150), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
          method()
      end
    end
  end

  if text == "Extra D" then
    --ui.drawRect(vec2(540,145), vec2(560,165), rgbm(0.8, 0.8, 0.8, 1), 20, 15, 10)
    ui.drawCircle(vec2(650, 200), 10, color, 25, 10)

    if ui.rectHovered(vec2(640,190), vec2(660,210)) then
      ui.drawCircle(vec2(650, 200), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
          method()
      end
    end
  end

  if text == "Extra E" then
    --ui.drawRect(vec2(540,145), vec2(560,165), rgbm(0.8, 0.8, 0.8, 1), 20, 15, 10)
    ui.drawCircle(vec2(680, 280), 10, color, 25, 10)

    if ui.rectHovered(vec2(670,270), vec2(690,290)) then
      ui.drawCircle(vec2(680, 280), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
          method()
      end
    end
  end

  if text == "Extra F" then
    --ui.drawRect(vec2(540,145), vec2(560,165), rgbm(0.8, 0.8, 0.8, 1), 20, 15, 10)
    ui.drawCircle(vec2(480, 200), 10, color, 25, 10)

    if ui.rectHovered(vec2(470,190), vec2(490,210)) then
      ui.drawCircle(vec2(480, 200), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
        method()
      end
    end
  end

  if text == "Front Lift" then
    if frLift == true then
      color = onColor
    else
      color = offColor
    end

    --ui.drawRect(vec2(540,145), vec2(560,165), rgbm(0.8, 0.8, 0.8, 1), 20, 15, 10)
    ui.drawCircle(vec2(230, 360), 10, color, 25, 10)

    if ui.rectHovered(vec2(220,350), vec2(240,370)) then
      ui.drawCircle(vec2(230, 360), 10, rgbm(1, 0, 0, 1), 25, 10)
      if ui.mouseClicked() then
        method()
      end
    end
  end

end